﻿using System;
using System.Linq;
using VRM.Integration.FTP.MVI.Messages;
using IMessageBase = VRM.Integration.Servicebus.Core.IMessageBase;
using Logger = VRM.Integration.Servicebus.Core.Logger;
using VRM.Integration.Servicebus.Core;
using MVIMessages = VRM.Integration.Mvi.PersonSearch.Messages;
using VRM.Integration.Mvi.PersonSearch;
using VRM.Integration.Servicebus.Logging.CRM.Util;
using VRM.Integration.FTP.MVI;
using VRM.Integration.FTP.MVI.MVIPersonSearch;
using VRM.Integration.FTP.MVI.Transformer;

namespace VRM.Integration.FTP.MVI.Processors
{
    public class FTPDeterministicSearchProcessor
    {
        private const string MVISearchResultsWithMatch = "A search in MVI found {0} matching record(s).";
        private const string MVISearchResultsWithNoMatch = "A search in MVI did not find any records matching the search criteria.";
       // MVIResponseTransformer MVITransformer { get; set; }

        public FTPDeterministicSearchProcessor()
        {
           // MVITransformer = new MVIResponseTransformer();
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        public IMessageBase Execute(FTPDeterministicSearchRequest request)
        {
            FTPPersonSearchResponse response = new FTPPersonSearchResponse();

            try
            {
               if (request == null)
                {
                    Logger.Instance.Warn(string.Format("{0} recieved a null message", GetType().FullName));
                    response.ExceptionOccured = true;
                    response.MVIMessage = string.Format("{0} recieved a null message", GetType().FullName);
                }
                else
                {
                    Logger.Instance.Info(string.Format("Message Id:{0}, Type={2}, Recieved diagnostics message: {1}",
                        request.MessageId,
                        request.MessageId,
                        GetType().FullName));

                    var personSearch = new PersonSearch();
                    response = personSearch.DeterministicSearch(request);

                    Logger.Instance.Info(string.Format("PersonSearch.Attended Search Result - MessageID: {0}", response.MessageId));
                }

                return response;
            }
            catch (Exception ex)
            {
                Logger.Instance.Error(string.Format("FTPDeterministicSearchProcessor Error: {0}", ex.Message));
                Logger.Instance.Error(string.Format("FTPDeterministicSearchProcessor Error Stack: {0}", ex.StackTrace));
                LogHelper.LogError(request.OrganizationName, request.UserId, "FTPDeterministicSearchProcessor, Execute", "Exception:" + ex.Message);
                response.ExceptionOccured = true;
                response.MVIMessage = ex.Message;

                return response;
            }            
        }
    }
}

